import {Readable} from 'stream';

import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';
import {IDependencies} from 'server/getContainerConfig';
import {ImageGeneratorService} from 'server/services/ImageGeneratorService/ImageGeneratorService';

export class ShareImageController {
    private imageGeneratorService: ImageGeneratorService;

    constructor({imageGeneratorService}: IDependencies) {
        this.imageGeneratorService = imageGeneratorService;
    }

    @logAction
    @requestMethod('GET')
    get(req: Request, res: Response): void {
        this.imageGeneratorService
            .generate(req.query)
            .then(this.sendImageResponse(res))
            .catch(handleError(res));
    }

    @logAction
    @requestMethod('GET')
    ping(req: Request, res: Response): void {
        this.imageGeneratorService
            .ping()
            .then(handleResponse(res), handleError(res));
    }

    private sendImageResponse =
        (res: Response) =>
        (data: Readable): void => {
            res.type('image/png');
            data.pipe(res);
        };
}
