import {HTTP_BAD_REQUEST_CODE} from 'server/constants/httpCodes';
import {ESolomonSensorType} from 'server/constants/solomon';

import {Request, Response} from '@yandex-data-ui/core/lib/types';

import requestMethod from 'server/utilities/decorators/requestMethod';
import {logAction} from 'server/utilities/decorators/logAction';
import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {ApiBaseController} from 'server/controllers/ApiBaseController';

import * as SOLOMON_SENSORS from '../../../tools/solomon';

interface IPushSolomonCounterRequest {
    sensor: ESolomonSensorType;
    name: string;
    labels: any;
    value: any;
}

export class SolomonApiController extends ApiBaseController {
    @logAction
    @requestMethod('POST')
    push(req: Request, res: Response): void {
        const {sensor, name, labels, value}: IPushSolomonCounterRequest =
            req.body;
        const sensorSender = SOLOMON_SENSORS[sensor];

        if (sensorSender) {
            sensorSender(name, labels, value)
                .then(this.sendSuccessResponse(res))
                .catch(this.sendErrorResponse(res));
        } else {
            res.status(HTTP_BAD_REQUEST_CODE).send({
                error: `Unknown sensor type "${sensor}"`,
            });
        }
    }
}

export default makeProxyInvoker(SolomonApiController);
