import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {NotifierController} from './NotifierController';
import {CountriesController} from './CountriesController';
import {CurrenciesController} from './CurrenciesController';
import {TinyUrlController} from './TinyUrlController';
import {SolomonApiController} from './SolomonApiController';
import {GeobaseApiController} from './GeobaseApiController';
import {ShareImageController} from './ShareImageController';
import {CommonController} from './CommonController';
import {ExperimentsController} from './ExperimentsController';

const tinyUrlController = makeProxyInvoker(TinyUrlController);
const shareImageController = makeProxyInvoker(ShareImageController);
const notifierController = makeProxyInvoker(NotifierController);
const countriesController = makeProxyInvoker(CountriesController);
const currenciesController = makeProxyInvoker(CurrenciesController);
const solomonApiController = makeProxyInvoker(SolomonApiController);
const geobaseApiController = makeProxyInvoker(GeobaseApiController);
const commonController = makeProxyInvoker(CommonController);
const experimentsController = makeProxyInvoker(ExperimentsController);

export default {
    countries: countriesController.getCountries,
    currencies: currenciesController.getCurrencies,
    storeTinyUrl: tinyUrlController.store,
    restoreTinyUrl: tinyUrlController.restore,
    solomon: solomonApiController.push,
    shareImages: shareImageController.get,
    shareImagesPing: shareImageController.ping,
    crossLinks: {
        getCrossLinks: commonController.getCrossLinks,
    },
    yandexPlus: {
        getUserYandexPlusInfo: commonController.getUserYandexPlusInfo,
    },
    notifier: {
        subscribe: notifierController.subscribe,
        unsubscribe: notifierController.unsubscribe,
        getStatus: notifierController.getStatus,
        getPromoConfig: notifierController.getPromoConfig,
    },
    geobase: {
        getUserGeoLocation: geobaseApiController.getUserGeoLocation,
    },
    experiments: experimentsController.experiments,
};
