import {Request, Response} from '@yandex-data-ui/core/lib/types';

import requestMethod from 'server/utilities/decorators/requestMethod';
import {logAction} from 'server/utilities/decorators/logAction';

import {CrossSearchService} from 'server/services/CrossSearchService/CrossSearchService';

import {IDependencies} from '../../getContainerConfig';
import {handleResponse} from '../handleResponse';
import {handleError} from '../handleError';

export class CrossSearchApiController {
    private crossSearchService: CrossSearchService;

    constructor({crossSearchService}: IDependencies) {
        this.crossSearchService = crossSearchService;
    }

    @logAction
    @requestMethod('GET')
    transformSearchContext(req: Request, res: Response): void {
        this.crossSearchService
            .transformSearchContext(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
