import _get from 'lodash/get';

import {Response} from '@yandex-data-ui/core/lib/types';

export interface IBaseErrorResponse<T = any> {
    statusCode: number;
    error?: any;
    data?: T;
}

export interface IBaseSuccessResponse<T> {
    statusCode: number;
    error: null;
    data: T;
}

enum EStatusCodes {
    UNKNOWN_ERROR_STATUS_CODE = 502,
}

export class HotelsBaseController {
    sendSuccessResponse =
        <T>(res: Response) =>
        (data: T): void => {
            res.json({
                data,
                error: null,
            });
        };

    baseApiErrorHandler = (apiError: any): IBaseErrorResponse => {
        const responseStatusCode = _get(apiError, 'response.status');

        return {
            statusCode:
                responseStatusCode || EStatusCodes.UNKNOWN_ERROR_STATUS_CODE,
        };
    };

    sendErrorResponse =
        <T extends IBaseErrorResponse>(
            res: Response,
            prepareErrorResponse: (apiError: any) => T,
        ) =>
        (apiError: any): void => {
            const {statusCode, error, data} = prepareErrorResponse(apiError);

            res.status(statusCode).send({
                error: error || null,
                data: data || null,
            });
        };
}

export default HotelsBaseController;
