import {Request, Response} from '@yandex-data-ui/core/lib/types';

import requestMethod from 'server/utilities/decorators/requestMethod';
import {logAction} from 'server/utilities/decorators/logAction';

import {HotelsCrossSaleService} from 'server/services/HotelsServices/HotelsCrossSaleService';

import {IDependencies} from '../../getContainerConfig';
import HotelsBaseController from './HotelsBaseController';
import {handleResponse} from '../handleResponse';

export class HotelsCrossSaleApiController extends HotelsBaseController {
    private hotelsCrossSaleService: HotelsCrossSaleService;

    constructor({hotelsCrossSaleService}: IDependencies) {
        super();

        this.hotelsCrossSaleService = hotelsCrossSaleService;
    }

    @logAction
    @requestMethod('GET')
    getCrossSaleHotelsV1(req: Request, res: Response): void {
        this.hotelsCrossSaleService
            .getCrossSaleHotelsV1(req.query)
            .then(handleResponse(res))
            .catch(this.sendErrorResponse(res, this.baseApiErrorHandler));
    }

    @logAction
    @requestMethod('GET')
    getCrossSaleHotelsV3(req: Request, res: Response): void {
        this.hotelsCrossSaleService
            .getCrossSaleHotelsV3(req.query)
            .then(handleResponse(res))
            .catch(this.sendErrorResponse(res, this.baseApiErrorHandler));
    }
}
