import {Request, Response} from '@yandex-data-ui/core/lib/types';

import requestMethod from 'server/utilities/decorators/requestMethod';
import {logAction} from 'server/utilities/decorators/logAction';

import {HotelsFavoritesService} from 'server/services/HotelsServices/HotelsFavoritesService';

import {IDependencies} from '../../getContainerConfig';
import HotelsBaseController from './HotelsBaseController';

export class HotelsFavoritesController extends HotelsBaseController {
    private hotelsFavoritesService: HotelsFavoritesService;

    constructor({hotelsFavoritesService}: IDependencies) {
        super();

        this.hotelsFavoritesService = hotelsFavoritesService;
    }

    @logAction
    @requestMethod('POST')
    addFavoriteHotel(req: Request, res: Response): void {
        this.hotelsFavoritesService
            .addFavoriteHotel(req.query)
            .then(this.sendSuccessResponse(res))
            .catch(this.sendErrorResponse(res, this.baseApiErrorHandler));
    }

    @logAction
    @requestMethod('POST')
    removeFavoriteHotels(req: Request, res: Response): void {
        this.hotelsFavoritesService
            .removeFavoriteHotels(req.query)
            .then(this.sendSuccessResponse(res))
            .catch(this.sendErrorResponse(res, this.baseApiErrorHandler));
    }

    @logAction
    @requestMethod('GET')
    getFavoriteHotels(req: Request, res: Response): void {
        this.hotelsFavoritesService
            .getFavoriteHotels(req.query)
            .then(this.sendSuccessResponse(res))
            .catch(this.sendErrorResponse(res, this.baseApiErrorHandler));
    }

    @logAction
    @requestMethod('GET')
    getFavoriteHotelsOffers(req: Request, res: Response): void {
        this.hotelsFavoritesService
            .getFavoriteHotelsOffers(req.query)
            .then(this.sendSuccessResponse(res))
            .catch(this.sendErrorResponse(res, this.baseApiErrorHandler));
    }

    @logAction
    @requestMethod('POST')
    shareFavoriteHotels(req: Request, res: Response): void {
        this.hotelsFavoritesService
            .shareFavoriteHotels(req.query)
            .then(this.sendSuccessResponse(res))
            .catch(this.sendErrorResponse(res, this.baseApiErrorHandler));
    }

    @logAction
    @requestMethod('GET')
    getSharedFavoriteHotels(req: Request, res: Response): void {
        this.hotelsFavoritesService
            .getSharedFavoriteHotels(req.query)
            .then(this.sendSuccessResponse(res))
            .catch(this.sendErrorResponse(res, this.baseApiErrorHandler));
    }
}
