import {Request, Response} from '@yandex-data-ui/core/lib/types';
import {
    ISearchHotelsInfo,
    ISearchHotelsInfoError,
} from 'server/api/HotelsSearchAPI/types/ISearchHotels';
import {
    ISearchSuggestResponse,
    ISearchSuggestError,
} from 'server/api/HotelsSearchAPI/types/ISearchSuggest';
import {
    ILogSearchSuggestResponse,
    ILogSearchSuggestError,
} from 'server/api/HotelsSearchAPI/types/ILogSearchSuggest';
import {
    ICountHotelsError,
    ICountHotelsResponse,
} from 'server/api/HotelsSearchAPI/types/ICountHotels';
import {
    IGeoRegionInfoResponse,
    IGeoRegionInfoError,
} from 'server/api/HotelsSearchAPI/types/IGeoRegionInfo';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';
import {prepareSearchSuggestError} from 'server/api/HotelsSearchAPI/utilities/prepareSearchSuggest';
import {prepareSearchHotelsError} from 'server/api/HotelsSearchAPI/utilities/prepareSearchHotels';

import {HotelsSearchService} from 'server/services/HotelsServices/HotelsSearchService';
import {IDependencies} from 'server/getContainerConfig';

import HotelsBaseController from './HotelsBaseController';

export class HotelsSearchController extends HotelsBaseController {
    private hotelsSearchService: HotelsSearchService;

    constructor({hotelsSearchService}: IDependencies) {
        super();

        this.hotelsSearchService = hotelsSearchService;
    }

    /* SearchSuggest in HotelsForm */
    @logAction
    @requestMethod('GET')
    searchSuggest(req: Request, res: Response): void {
        this.hotelsSearchService
            .searchSuggest(req.query)
            .then(this.sendSuccessResponse<ISearchSuggestResponse>(res))
            .catch(
                this.sendErrorResponse<ISearchSuggestError>(
                    res,
                    prepareSearchSuggestError,
                ),
            );
    }

    /* LogSearchSuggest in HotelsForm */
    @logAction
    @requestMethod('POST')
    logSearchSuggest(req: Request, res: Response): void {
        this.hotelsSearchService
            .logSearchSuggest(req.body)
            .then(this.sendSuccessResponse<ILogSearchSuggestResponse>(res))
            .catch(
                this.sendErrorResponse<ILogSearchSuggestError>(
                    res,
                    this.baseApiErrorHandler,
                ),
            );
    }

    /* SearchHotels */
    @logAction
    @requestMethod('GET')
    searchHotels(req: Request, res: Response): void {
        this.hotelsSearchService
            .searchHotels(req.query)
            .then(this.sendSuccessResponse<ISearchHotelsInfo>(res))
            .catch(
                this.sendErrorResponse<ISearchHotelsInfoError>(
                    res,
                    prepareSearchHotelsError,
                ),
            );
    }

    @logAction
    @requestMethod('GET')
    countHotels(req: Request, res: Response): void {
        this.hotelsSearchService
            .countHotels(req.query)
            .then(this.sendSuccessResponse<ICountHotelsResponse>(res))
            .catch(
                this.sendErrorResponse<ICountHotelsError>(
                    res,
                    this.baseApiErrorHandler,
                ),
            );
    }

    /* GeoRegion */
    @logAction
    @requestMethod('GET')
    getGeoRegionInfo(req: Request, res: Response): void {
        this.hotelsSearchService
            .getGeoRegionInfo(req.query)
            .then(this.sendSuccessResponse<IGeoRegionInfoResponse>(res))
            .catch(
                this.sendErrorResponse<IGeoRegionInfoError>(
                    res,
                    this.baseApiErrorHandler,
                ),
            );
    }
}
