import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {HotelsSearchController} from './HotelsSearchController';
import {HotelSearchController} from './HotelSearchController';
import {HotelsBookController} from './HotelsBookController';
import {HotelsFavoritesController} from './HotelsFavoritesController';
import {HotelsCrossSaleApiController} from './HotelsCrossSaleApiController';

const hotelsBookController = makeProxyInvoker(HotelsBookController);
const hotelsSearchController = makeProxyInvoker(HotelsSearchController);
const hotelSearchController = makeProxyInvoker(HotelSearchController);
const hotelsFavoritesController = makeProxyInvoker(HotelsFavoritesController);
const hotelsCrossSaleApiController = makeProxyInvoker(
    HotelsCrossSaleApiController,
);

export default {
    /* IndexPage */
    searchSuggest: hotelsSearchController.searchSuggest,
    logSearchSuggest: hotelsSearchController.logSearchSuggest,

    /* SearchPage */
    searchHotels: hotelsSearchController.searchHotels,
    countHotels: hotelsSearchController.countHotels,

    /* GeoRegionPage */
    getGeoRegionInfo: hotelsSearchController.getGeoRegionInfo,

    /* LegacyHotelPage */
    getLegacyHotelInfo: hotelSearchController.getLegacyHotelInfo,

    /* HotelPage */
    getHotelInfo: hotelSearchController.getHotelInfo,
    getCalendarPrices: hotelSearchController.getCalendarPrices,
    getHotelImages: hotelSearchController.getHotelImages,
    getHotelReviews: hotelSearchController.getHotelReviews,
    addHotelReview: hotelSearchController.addHotelReview,
    editHotelReview: hotelSearchController.editHotelReview,
    deleteHotelReview: hotelSearchController.deleteHotelReview,
    uploadHotelReviewImage: hotelSearchController.uploadHotelReviewImage,
    deleteHotelReviewImages: hotelSearchController.deleteHotelReviewImages,
    getHotelOffers: hotelSearchController.getHotelOffers,
    getSimilarHotels: hotelSearchController.getSimilarHotels,
    setHotelReviewReaction: hotelSearchController.setHotelReviewReaction,

    /* Favorites */
    addFavoriteHotel: hotelsFavoritesController.addFavoriteHotel,
    removeFavoriteHotels: hotelsFavoritesController.removeFavoriteHotels,
    getFavoriteHotels: hotelsFavoritesController.getFavoriteHotels,
    getFavoriteHotelsOffers: hotelsFavoritesController.getFavoriteHotelsOffers,
    shareFavoriteHotels: hotelsFavoritesController.shareFavoriteHotels,
    getSharedFavoriteHotels: hotelsFavoritesController.getSharedFavoriteHotels,

    /* BookAndPayPage */
    offerInfoByToken: hotelsBookController.offerInfoByToken,
    createOrder: hotelsBookController.createOrder,
    estimateDiscount: hotelsBookController.estimateDiscount,
    startPayment: hotelsBookController.startPayment,
    getOrder: hotelsBookController.getOrder,
    getOrderStatus: hotelsBookController.getOrderStatus,
    getOrderRefundableInfo: hotelsBookController.getOrderRefundableInfo,
    cancelOrder: hotelsBookController.cancelOrder,
    removeOrder: hotelsBookController.removeOrder,
    checkVoucher: hotelsBookController.checkVoucher,
    voucher: hotelsBookController.downloadVoucher,
    generateBusinessTripPdf: hotelsBookController.generateBusinessTripPdf,
    checkBusinessTripPdf: hotelsBookController.checkBusinessTripPdf,
    businessTripPdf: hotelsBookController.downloadBusinessTripPdf,
    getTestBookOfferToken: hotelsBookController.getTestBookOfferToken,
    getCrossSaleHotelsV1: hotelsCrossSaleApiController.getCrossSaleHotelsV1,
    getCrossSaleHotelsV3: hotelsCrossSaleApiController.getCrossSaleHotelsV3,
};
