import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {HotelsExtranetService} from 'server/services/HotelsExtranetService/HotelsExtranetService';
import {IDependencies} from 'server/getContainerConfig';

export class HotelsExtranetController {
    private hotelsExtranetService: HotelsExtranetService;

    constructor({hotelsExtranetService}: IDependencies) {
        this.hotelsExtranetService = hotelsExtranetService;
    }

    @logAction
    @requestMethod('POST')
    addHotel(req: Request, res: Response): void {
        this.hotelsExtranetService
            .addHotel(req.body)
            .then(data => res.json(data))
            .catch(error => this.handleError(res, error));
    }

    @logAction
    @requestMethod('POST')
    approveHotel(req: Request, res: Response): void {
        this.hotelsExtranetService
            .approveHotel(req.body)
            .then(data => res.json(data))
            .catch(error => this.handleError(res, error));
    }

    @logAction
    @requestMethod('GET')
    getHotels(req: Request, res: Response): void {
        this.hotelsExtranetService
            .getHotels()
            .then(data => res.json(data))
            .catch(error => this.handleError(res, error));
    }

    @logAction
    @requestMethod('POST')
    getOrders(req: Request, res: Response): void {
        this.hotelsExtranetService
            .getOrders(req.body)
            .then(data => res.json(data))
            .catch(error => this.handleError(res, error));
    }

    @logAction
    @requestMethod('POST')
    getPayments(req: Request, res: Response): void {
        this.hotelsExtranetService
            .getPayments(req.body)
            .then(data => res.json(data))
            .catch(error => this.handleError(res, error));
    }

    @logAction
    @requestMethod('GET')
    getPaymentDetails(req: Request, res: Response): void {
        this.hotelsExtranetService
            .getPaymentDetails(req.query)
            .then(data => res.json(data))
            .catch(error => this.handleError(res, error));
    }

    private handleError(res: Response, reaspon: any): void {
        res.status(reaspon?.response?.status).send();
    }
}
