import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {IDependencies} from 'server/getContainerConfig';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';
import {LevelTravelService} from 'server/services/LevelTravelService/LevelTravelService';

export class LevelTravelApiController {
    private levelTravelService: LevelTravelService;

    constructor({levelTravelService}: IDependencies) {
        this.levelTravelService = levelTravelService;
    }

    @logAction
    @requestMethod('GET')
    getAvailableCountries(req: Request, res: Response): void {
        this.levelTravelService
            .getAvailableCountries(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getCountries(req: Request, res: Response): void {
        this.levelTravelService
            .getCountries(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    autocomplete(req: Request, res: Response): void {
        this.levelTravelService
            .autocomplete(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getDepartures(req: Request, res: Response): void {
        this.levelTravelService
            .getDepartures(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getFlightsAndNights(req: Request, res: Response): void {
        this.levelTravelService
            .getFlightsAndNights(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getRedirect(req: Request, res: Response): void {
        this.levelTravelService
            .getRedirect(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
