import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';
import {authorize} from 'server/utilities/decorators/authorize';

import {IDependencies} from 'server/getContainerConfig';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';
import {NotebookService} from 'server/services/NotebookService/NotebookService';

export class NotebookApiController {
    private notebookService: NotebookService;

    constructor({notebookService}: IDependencies) {
        this.notebookService = notebookService;
    }

    @authorize
    @logAction
    @requestMethod('GET')
    getTraveler(req: Request, res: Response): void {
        this.notebookService
            .getTraveler(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('POST')
    createOrUpdateTraveler(req: Request, res: Response): void {
        this.notebookService
            .createOrUpdateTraveler(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('GET')
    getPassengers(req: Request, res: Response): void {
        this.notebookService
            .getPassengers(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('GET')
    getPassenger(req: Request, res: Response): void {
        this.notebookService
            .getPassenger(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('POST')
    createPassenger(req: Request, res: Response): void {
        this.notebookService
            .createPassenger(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('PUT')
    editPassenger(req: Request, res: Response): void {
        this.notebookService
            .editPassenger(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('DELETE')
    deletePassenger(req: Request, res: Response): void {
        this.notebookService
            .deletePassenger(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('GET')
    getPassengerDocuments(req: Request, res: Response): void {
        this.notebookService
            .getPassengerDocuments(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('GET')
    getPassengerDocument(req: Request, res: Response): void {
        this.notebookService
            .getPassengerDocument(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('POST')
    createPassengerDocument(req: Request, res: Response): void {
        this.notebookService
            .createPassengerDocument(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('PUT')
    editPassengerDocument(req: Request, res: Response): void {
        this.notebookService
            .editPassengerDocument(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('DELETE')
    deletePassengerDocument(req: Request, res: Response): void {
        this.notebookService
            .deletePassengerDocument(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('GET')
    getPassengerBonusCards(req: Request, res: Response): void {
        this.notebookService
            .getPassengerBonusCards(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('GET')
    getPassengerBonusCard(req: Request, res: Response): void {
        this.notebookService
            .getPassengerBonusCard(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('POST')
    createPassengerBonusCard(req: Request, res: Response): void {
        this.notebookService
            .createPassengerBonusCard(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('PUT')
    editPassengerBonusCard(req: Request, res: Response): void {
        this.notebookService
            .editPassengerBonusCard(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('DELETE')
    deletePassengerBonusCard(req: Request, res: Response): void {
        this.notebookService
            .deletePassengerBonusCard(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('GET')
    getDocumentTypes(req: Request, res: Response): void {
        this.notebookService
            .getDocumentTypes()
            .then(handleResponse(res), handleError(res));
    }

    @authorize
    @logAction
    @requestMethod('POST')
    saveTravelerAndPassengers(req: Request, res: Response): void {
        this.notebookService
            .saveTravelerAndPassengers(req.body)
            .then(handleResponse(res), handleError(res));
    }
}
