import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {NotebookApiController} from './NotebookApiController';

const notebookApiController = makeProxyInvoker(NotebookApiController);

export default {
    getTraveler: notebookApiController.getTraveler,
    createOrUpdateTraveler: notebookApiController.createOrUpdateTraveler,

    getPassengers: notebookApiController.getPassengers,
    getPassenger: notebookApiController.getPassenger,
    createPassenger: notebookApiController.createPassenger,
    editPassenger: notebookApiController.editPassenger,
    deletePassenger: notebookApiController.deletePassenger,

    getPassengerDocuments: notebookApiController.getPassengerDocuments,
    getPassengerDocument: notebookApiController.getPassengerDocument,
    createPassengerDocument: notebookApiController.createPassengerDocument,
    editPassengerDocument: notebookApiController.editPassengerDocument,
    deletePassengerDocument: notebookApiController.deletePassengerDocument,

    getPassengerBonusCards: notebookApiController.getPassengerBonusCards,
    getPassengerBonusCard: notebookApiController.getPassengerBonusCard,
    createPassengerBonusCard: notebookApiController.createPassengerBonusCard,
    editPassengerBonusCard: notebookApiController.editPassengerBonusCard,
    deletePassengerBonusCard: notebookApiController.deletePassengerBonusCard,

    getDocumentTypes: notebookApiController.getDocumentTypes,

    saveTravelerAndPassengers: notebookApiController.saveTravelerAndPassengers,
};
