import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {IDependencies} from 'server/getContainerConfig';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';
import {OrdersService} from 'server/services/OrdersService/OrdersService';
import {TestContextService} from 'server/services/TestContextService/TestContextService';

export class OrdersApiController {
    private ordersService: OrdersService;
    private testContextService: TestContextService;

    constructor({ordersService, testContextService}: IDependencies) {
        this.ordersService = ordersService;
        this.testContextService = testContextService;
    }

    @logAction
    @requestMethod('GET')
    getOrderHappyPage(req: Request, res: Response): void {
        this.ordersService
            .getOrderHappyPage(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getUserPromoAttributes(req: Request, res: Response): void {
        this.ordersService
            .getUserPromoAttributes()
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    checkOrderAuthorization(req: Request, res: Response): void {
        this.ordersService
            .checkOrderAuthorization(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('POST')
    createOrderAuthorization(req: Request, res: Response): void {
        this.ordersService
            .createOrderAuthorization(req.body)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    getPaymentTestContextToken(req: Request, res: Response): void {
        this.testContextService
            .getPaymentTestContextToken(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
