import {Request, Response} from '@yandex-data-ui/core/lib/types';

import requestMethod from 'server/utilities/decorators/requestMethod';
import {logAction} from 'server/utilities/decorators/logAction';

import {PersonalizationService} from 'server/services/PersonalizationService/PersonalizationService';

import {IDependencies} from '../../getContainerConfig';
import {handleResponse} from '../handleResponse';
import {handleError} from '../handleError';

export class PersonalizationController {
    private personalizationService: PersonalizationService;

    constructor({personalizationService}: IDependencies) {
        this.personalizationService = personalizationService;
    }

    @logAction
    @requestMethod('GET')
    getHotelsSuggests(req: Request, res: Response): void {
        this.personalizationService
            .getHotelsSuggests(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    getAviaSearchHistory(req: Request, res: Response): void {
        this.personalizationService
            .getAviaSearchHistory(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
