const path = require('path');
const webpackUtilitiesPath = path.resolve(
    __dirname,
    '..',
    '..',
    'webpack',
    'utilities',
    'getPathParams.js',
);
const {serverBuildPath} = require(webpackUtilitiesPath);

if (process.env.NODE_ENV === 'production') {
    module.exports = require(`${serverBuildPath}/renderAmpServer.js`).default();
} else {
    /** В dev режиме импорт находится внутри функции, т.к. импорт модуля должен происходить на каждый ребилд */
    module.exports = (req, res) => {
        const devRenderer =
            require(`${serverBuildPath}/renderAmpServer.js`).default();

        return devRenderer(req, res);
    };
}
