import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {IDependencies} from 'server/getContainerConfig';
import {handleError} from 'server/controllers/handleError';
import {handleResponse} from 'server/controllers/handleResponse';
import {ReviewsService} from 'server/services/ReviewsService/ReviewsService';

export class ReviewsController {
    private reviewsService: ReviewsService;

    constructor({reviewsService}: IDependencies) {
        this.reviewsService = reviewsService;
    }

    @logAction
    @requestMethod('GET')
    getTrainsReviews(req: Request, res: Response): void {
        this.reviewsService
            .getTrainsReviews(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
