import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';
import requiredParams from 'server/utilities/decorators/requiredParams';

import {TemplatorService} from 'server/services/TemplatorService/TemplatorService';

import {IDependencies} from '../../getContainerConfig';
import {handleResponse} from '../handleResponse';
import {handleError} from '../handleError';

export class TemplatorController {
    private templatorService: TemplatorService;

    constructor({templatorService}: IDependencies) {
        this.templatorService = templatorService;
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['device', 'semantic_id'])
    getRootMeta(req: Request, res: Response): void {
        this.templatorService
            .getRootMeta(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['device', 'semantic_id'])
    getArticle(req: Request, res: Response): void {
        this.templatorService
            .getArticle(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['device'])
    getArticles(req: Request, res: Response): void {
        this.templatorService
            .getArticles(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['device'])
    getTagsList(req: Request, res: Response): void {
        this.templatorService
            .getTagsList(req.query)
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['device', 'tagSlug'])
    getTagInfo(req: Request, res: Response): void {
        this.templatorService
            .getTagInfo(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
