import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';

import {IDependencies} from 'server/getContainerConfig';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';
import {ToursService} from 'server/services/ToursService/ToursService';

export class ToursApiController {
    private toursService: ToursService;

    constructor({toursService}: IDependencies) {
        this.toursService = toursService;
    }

    @logAction
    @requestMethod('GET')
    getToursWidgetInfo(req: Request, res: Response): void {
        this.toursService
            .getToursWidgetInfo()
            .then(handleResponse(res), handleError(res));
    }

    @logAction
    @requestMethod('POST')
    bindTour(req: Request, res: Response): void {
        this.toursService
            .bindTour(req.query)
            .then(handleResponse(res), handleError(res));
    }
}
