import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {TrainsApiController} from './TrainsApiController';

const {
    getSuggests,
    activePartners,
    parseContext,
    getTariffs,
    countries,
    saveOffer,
    saveDocumentsAndTravelerToNotebook,
    addInsurance,
    orderSegment,
    trainDetails,
    logBandit,
    ticket,
    testContextToken,
    getActualizedTrainApiOrder,
    changeOrderRegistrationStatus,
    downloadBlank,
    downloadBlankFromTrainApi,
    genericSearch,
    priceCalendar,
    getCrossLinks,
    getFirmTrain,
    getDirectionSearch,
} = makeProxyInvoker(TrainsApiController);

export default {
    'parse-context': parseContext,
    activePartners,
    tariffs: getTariffs,
    searchSuggest: getSuggests,
    trainDetails,
    orderSegment,
    addInsurance,
    countries,
    saveOffer,
    saveDocumentsAndTravelerToNotebook,
    logBandit,
    ticket,
    testContextToken,
    getActualizedTrainApiOrder,
    changeOrderRegistrationStatus,
    downloadBlank,
    downloadBlankFromTrainApi,
    genericSearch,
    priceCalendar,
    getCrossLinks,
    getFirmTrain,
    getDirectionSearch,
};
