import {AxiosError} from 'axios';

import {EOrderErrorType} from 'projects/trains/constants/orderErrors';

import {IOrderError} from 'reducers/trains/order/types';

import {IRawPartnerError} from 'server/controllers/trainsApiController/utilities/fillError';
import isAxiosError from 'utilities/api/isAxiosError';

import parseErrors from './parseErrors';

/**
 * Возвращает ошибку для ручек заказа
 */
export default function getOrderError(
    err:
        | Error
        | AxiosError<{errors: Record<EOrderErrorType, IRawPartnerError>}>,
): IOrderError {
    if (!isAxiosError(err)) {
        return {
            type: EOrderErrorType.INTERNAL_ERROR,
        };
    }

    const errors = err?.response?.data?.errors;

    return (
        parseErrors(errors) || {
            type: EOrderErrorType.INTERNAL_ERROR,
        }
    );
}
