import {EOrderErrorType} from 'projects/trains/constants/orderErrors';

import {IOrderError} from 'reducers/trains/order/types';

import fillError, {IRawPartnerError} from './fillError';

/**
 * Парсим ошибки от бекенда
 */
export default function parseErrors(
    errors: Record<EOrderErrorType, IRawPartnerError> | undefined,
): IOrderError | null {
    if (!errors) {
        return null;
    }

    if (errors[EOrderErrorType.INTERNAL_ERROR]) {
        return fillError(errors[EOrderErrorType.INTERNAL_ERROR]);
    }

    /**
     * Ошибок может быть несколько (в теории)
     * Пока таких кейсов нет, но на всякий случай пытаемся вернуть
     * наиболее приоритетную ошибку, если такой нет - первую, которую найдем
     */
    const errorType = Object.values(EOrderErrorType).find(type =>
        Boolean(errors[type]),
    );

    if (!errorType) {
        return null;
    }

    return fillError(errors[errorType]);
}
