import {Request, Response} from '@yandex-data-ui/core/lib/types';

import {logAction} from 'server/utilities/decorators/logAction';
import requestMethod from 'server/utilities/decorators/requestMethod';
import requiredParams from 'server/utilities/decorators/requiredParams';
import makeProxyInvoker from 'server/utilities/makeProxyInvoker';

import {WeatherService} from 'server/services/WeatherService/WeatherService';
import {IDependencies} from 'server/getContainerConfig';
import {handleResponse} from 'server/controllers/handleResponse';
import {handleError} from 'server/controllers/handleError';

export class WeatherApiController {
    private weatherService: WeatherService;

    constructor({weatherService}: IDependencies) {
        this.weatherService = weatherService;
    }

    @logAction
    @requestMethod('GET')
    @requiredParams(['geoId', 'startDate', 'days'])
    getWeatherForecastByGeoId(req: Request, res: Response): void {
        this.weatherService
            .getWeatherForecastByGeoId(req.query)
            .then(handleResponse(res), handleError(res));
    }
}

export default makeProxyInvoker(WeatherApiController);
