import {EProjectName} from 'constants/common';

import {TAviaLogAction} from './types/TAviaLogAction';

import {AVIA_ACTION_LOG_NAME} from '../utils/aviaLoggerConstants';
import {TFileLoggerWrapperGetter} from 'server/loggers/utils/getFileLoggerWrapper';
import {AviaJSONLog} from '../utils/AviaJSONLog';
import {decodeQidOrDefault} from 'projects/avia/lib/qid';

export function createAviaActionLog(
    getFileLoggerWrapper: TFileLoggerWrapperGetter,
): TAviaLogAction {
    const {logger, config} = getFileLoggerWrapper(
        EProjectName.AVIA,
        AVIA_ACTION_LOG_NAME,
    );
    const actionLog = new AviaJSONLog(logger, config);

    return ({req, session, actionId, action, params, userSplit}): void => {
        actionLog.log(AVIA_ACTION_LOG_NAME, req, {
            ...params,
            session,
            actionId,
            action,
            test_buckets: userSplit.boxes,
            ...decodeQidOrDefault(params.qid),
        });
    };
}
