import {TAviaActionLogActionFilters} from 'server/loggers/avia/AviaActionLog/types/TAviaActionLogActionFilters';
import {EAviaLinkSource} from 'types/avia/url/EAviaLinkSource';

import {IAviaLogMetricsState} from 'reducers/avia/aviaLogMetrics/reducer';
import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';
import {IAviaSearchResultsSorting} from 'reducers/avia/search/results/reducer';

import {CurrencyType} from 'utilities/currency/CurrencyType';
import {EPriceHintType} from 'projects/avia/components/Dynamics/utilities/getPriceHintType';
import IPrice from 'utilities/currency/PriceInterface';

import {EAviaActionLogPageName} from './EAviaActionLogPageName';

export interface IAviaSearchActionLogMetrics extends IAviaLogMetricsState {
    userHasHistory: boolean;
}
export interface IAviaSearchActionLogParamsClient {
    page: EAviaActionLogPageName;
    currency: CurrencyType;
    qid: Nullable<string>;

    filters?: IAviaSearchResultsFilters;
    actionFilters?: TAviaActionLogActionFilters;
    scrollPage?: number;
    sort?: IAviaSearchResultsSorting;
    metrics?: IAviaSearchActionLogMetrics;
    dynamicPriceType?: EPriceHintType; // Тип цены в блоке динамики цен (в сравнении с другими датами цена приемлемая, высокая или низкая)
    dynamicPriceDiff?: IPrice; // Разница между минимальной ценой на запрошенную дату и минимальной ценой из данных о динамике цен
    linkSource?: EAviaLinkSource; // Источник ссылки. Пример: 'searchToCountry'
}

export interface IAviaOrderActionLogParamsClient {
    qid: Nullable<string>;
    page: EAviaActionLogPageName;
    currency: CurrencyType;
    baggage: boolean;

    searchIsCompleted: boolean;
    hasOffers: boolean;
}

export interface IAviaDynamicActionLogParamsClient {
    page: EAviaActionLogPageName;
}
