import {TAviaActionLogActionFilters} from 'server/loggers/avia/AviaActionLog/types/TAviaActionLogActionFilters';
import {EAviaLinkSource} from 'types/avia/url/EAviaLinkSource';

import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';

import {CurrencyType} from 'utilities/currency/CurrencyType';
import {EPriceHintType} from 'projects/avia/components/Dynamics/utilities/getPriceHintType';
import IPrice from 'utilities/currency/PriceInterface';

import {IAviaActionLogSorting} from './IAviaActionLogSorting';
import {EAviaActionLogPageName} from './EAviaActionLogPageName';
import {IAviaSearchActionLogMetrics} from './IAviaActionLogParamsClient';

export interface IAviaActionLogParamsServer {
    page: EAviaActionLogPageName;
    currency: CurrencyType;
    qid: Nullable<string>;

    baggage?: boolean;
    filters?: IAviaSearchResultsFilters;
    actionFilters?: TAviaActionLogActionFilters;
    scrollPage?: number;
    sort?: IAviaActionLogSorting;
    metrics?: IAviaSearchActionLogMetrics;
    /** Тип цены в блоке динамики цен (в сравнении с другими датами цена приемлемая, высокая или низкая) */
    dynamicPriceType?: EPriceHintType;
    /** Разница между минимальной ценой на запрошенную дату и минимальной ценой из данных о динамике цен */
    dynamicPriceDiff?: IPrice;
    /** Источник ссылки
     * @example 'searchToCountry'
     */
    linkSource?: EAviaLinkSource;
}
