import IPrice from 'types/common/price/IPrice';

import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';

import {EPriceHintType} from 'projects/avia/components/Dynamics/utilities/getPriceHintType';
import {CurrencyType} from 'utilities/currency/CurrencyType';

import {EAviaActionLogPageName} from './EAviaActionLogPageName';
import {IAviaActionLogSorting} from './IAviaActionLogSorting';

/**
 * Параметры экшен-логов динамики авиа
 */
export default interface IAviaDynamicActionLogParams {
    page: EAviaActionLogPageName;
    filters: IAviaSearchResultsFilters;
    currency: CurrencyType;
    qid: string | null;
    sort: IAviaActionLogSorting;
    dynamicPriceType: EPriceHintType; // Тип цены в блоке динамики цен (в сравнении с другими датами цена приемлемая, высокая или низкая)

    dynamicPriceDiff?: IPrice; // Разница между минимальной ценой на запрошенную дату и минимальной ценой из данных о динамике цен
}
