import {
    IAviaSearchBaggageFilter,
    IAviaSearchSegmentsAirportsFilter,
    IAviaSearchTimeFilter,
    IAviaSearchTransferFilter,
    IPriceFilter as IAviaSearchPriceFilter,
    TAviaFilterKey,
    TAviaSearchCompanyFilter,
    TAviaSearchPartnersFilter,
} from 'reducers/avia/search/results/filters/reducer';

interface IBaggageFilter {
    name: 'baggage';
    value: IAviaSearchBaggageFilter;
}

interface ITransferFilter {
    name: 'transfer';
    value: IAviaSearchTransferFilter;
}

interface ITimeFilter {
    name: 'time';
    value: IAviaSearchTimeFilter[];
}

interface ICompanyFilter {
    name: 'company';
    value: TAviaSearchCompanyFilter;
}

interface IAirportsFilter {
    name: 'airports';
    value: IAviaSearchSegmentsAirportsFilter[];
}

interface IPriceFilter {
    name: 'price';
    value: IAviaSearchPriceFilter;
}

interface IPartnersFilter {
    name: 'partners';
    value: TAviaSearchPartnersFilter;
}

interface IResetFilter {
    name: TAviaFilterKey | 'total';
    value: 'reset';
}

interface IUnknownFilter {
    name: 'UNKNOWN_ACTION';
}

export type TAviaActionLogActionFilters =
    | IBaggageFilter
    | ITransferFilter
    | ITimeFilter
    | ICompanyFilter
    | IAirportsFilter
    | IPriceFilter
    | IPartnersFilter
    | IResetFilter
    | IUnknownFilter;
