import {
    IAviaSearchActionLogParamsClient,
    IAviaOrderActionLogParamsClient,
} from '../types/IAviaActionLogParamsClient';
import {IAviaActionLogParamsServer} from '../types/IAviaActionLogParamsServer';

import prepareSearchSort from './prepareSearchSort';

export function aviaSearchActionLogPrepareParams(
    clientParams: IAviaSearchActionLogParamsClient,
): IAviaActionLogParamsServer {
    const {
        page,
        filters,
        currency,
        qid,
        scrollPage,
        sort,
        metrics,
        actionFilters,
        linkSource,
    } = clientParams;

    const params: IAviaActionLogParamsServer = {
        page,
        filters,
        currency,
        qid,
        scrollPage,
        metrics,
        actionFilters,
        linkSource,
    };

    if (sort) {
        params.sort = prepareSearchSort(sort);
    }

    return params;
}

export function aviaOrderActionLogPrepareParams(
    clientParams: IAviaOrderActionLogParamsClient,
): IAviaActionLogParamsServer {
    const {baggage, page, currency, qid} = clientParams;

    return {
        baggage,
        page,
        currency,
        qid,
    };
}
