import {EProjectName} from 'constants/common';

import {TAviaLogLandingVisit} from './types/TAviaLogLandingVisit';

import {AVIA_LANDING_VISIT_LOG_NAME} from '../utils/aviaLoggerConstants';
import {TFileLoggerWrapperGetter} from '../../utils/getFileLoggerWrapper';
import {AviaJSONLog} from '../utils/AviaJSONLog';

export function createAviaLandingLog(
    getfileLoggerWrapper: TFileLoggerWrapperGetter,
): TAviaLogLandingVisit {
    const {logger, config} = getfileLoggerWrapper(
        EProjectName.AVIA,
        AVIA_LANDING_VISIT_LOG_NAME,
    );
    const landingVisitLog = new AviaJSONLog(logger, config);

    return async (req, extra) => {
        landingVisitLog.log(AVIA_LANDING_VISIT_LOG_NAME, req, extra);
    };
}
