import {EProjectName} from 'constants/common';

import {Request} from '@yandex-data-ui/core/lib/types';

import {TFileLoggerWrapperGetter} from 'server/loggers/utils/getFileLoggerWrapper';
import {AVIA_POPULAR_FLIGHT_LOG_NAME} from '../utils/aviaLoggerConstants';
import {AviaTSKVLog} from '../utils/AviaTSKVLog';

import {IAviaOrderData} from 'server/controllers/aviaApiContoller/AviaRedirectController';

export type TLogPopularFlight = (
    req: Request,
    orderData: IAviaOrderData,
) => void;

export function createAviaPopularFlightLog(
    getfileLoggerWrapper: TFileLoggerWrapperGetter,
): TLogPopularFlight {
    const {logger, config} = getfileLoggerWrapper(
        EProjectName.AVIA,
        AVIA_POPULAR_FLIGHT_LOG_NAME,
    );
    const popularFlightLog = new AviaTSKVLog(logger, config);

    return (req, orderData) => {
        const flightsData = orderData.flightsData;

        popularFlightLog.log(AVIA_POPULAR_FLIGHT_LOG_NAME, req, {
            ...flightsData,
            tariff: orderData.tariff,
            national_version: orderData.national,
        });
    };
}
