import {EProjectName} from 'constants/common';

import {TLogRedirectError} from './types/TLogRedirectError';

import {AVIA_REDIRECT_ERROR_LOG_NAME} from '../utils/aviaLoggerConstants';
import {TFileLoggerWrapperGetter} from '../../utils/getFileLoggerWrapper';
import {decodeQidOrDefault} from 'projects/avia/lib/qid';
import {getAviaBillingPlatform} from '../utils/getAviaBillingPlatform';
import {AviaTSKVLog} from '../utils/AviaTSKVLog';

export function createAviaRedirectErrorLog(
    getfileLoggerWrapper: TFileLoggerWrapperGetter,
): TLogRedirectError {
    const {logger, config} = getfileLoggerWrapper(
        EProjectName.AVIA,
        AVIA_REDIRECT_ERROR_LOG_NAME,
    );
    const redirectErrorLog = new AviaTSKVLog(logger, config);

    return (req, e, userSplit) => {
        const {partner = 'unknown', qid, variantId} = req.query;
        const message = e.message || 'unknown';

        redirectErrorLog.logError(AVIA_REDIRECT_ERROR_LOG_NAME, e, req, {
            experimentsTestIds: userSplit.testIds,
            pp: getAviaBillingPlatform(req),
            partner,
            variantId,
            qid,
            message,
            ...decodeQidOrDefault(qid),
            ...req.aviaVisitSourceIds,
        });
    };
}
