import {EProjectName} from 'constants/common';

import {TAviaLogShow} from './types/TAviaLogShow';

import {AVIA_SHOW_LOG_NAME} from '../utils/aviaLoggerConstants';
import {TFileLoggerWrapperGetter} from 'server/loggers/utils/getFileLoggerWrapper';
import {AviaJSONLog} from '../utils/AviaJSONLog';

export function createAviaShowLog(
    getfileLoggerWrapper: TFileLoggerWrapperGetter,
): TAviaLogShow {
    const {logger, config} = getfileLoggerWrapper(
        EProjectName.AVIA,
        AVIA_SHOW_LOG_NAME,
    );
    const showLog = new AviaJSONLog(logger, config);

    return (req, variant, session, actionId) => {
        showLog.log(AVIA_SHOW_LOG_NAME, req, {
            session,
            actionId,
            ...variant,
        });
    };
}
