import {EProjectName} from 'constants/common';

import {TLogUserSearch} from './types/TLogUserSearch';

import {decodeQidOrDefault} from 'projects/avia/lib/qid';
import {AVIA_USER_SEARCH_LOG_NAME} from '../utils/aviaLoggerConstants';
import {TFileLoggerWrapperGetter} from '../../utils/getFileLoggerWrapper';
import {AviaJSONLog} from '../utils/AviaJSONLog';

export function createAviaUserSearchLog(
    getfileLoggerWrapper: TFileLoggerWrapperGetter,
): TLogUserSearch {
    const {logger, config} = getfileLoggerWrapper(
        EProjectName.AVIA,
        AVIA_USER_SEARCH_LOG_NAME,
    );
    const userSearchLog = new AviaJSONLog(logger, config);

    return (req, testBuckets, userCityId) => {
        const qid = req.body.qid;
        const page = req.body.page;

        userSearchLog.log(AVIA_USER_SEARCH_LOG_NAME, req, {
            qid,
            ...decodeQidOrDefault(qid),
            page,
            device_uuid: null,
            referer: null,
            test_buckets: testBuckets,
            user_from_key: userCityId,
        });
    };
}
