import Platforms from 'server/constants/platforms';

import {Request} from '@yandex-data-ui/core/lib/types';

// https://st.yandex-team.ru/RASPTICKETS-6728
// const BILLING_PLATFORM_RASP = 501; // 501 - десктоп Расписаний
const BILLING_PLATFORM_AVIA = 502; // 502 - десктоп Авиабилетов
const BILLING_PLATFORM_IOS_AVIA = 503; // 503 - приложение Авиабилетов под iOS
const BILLING_PLATFORM_ANDROID_AVIA = 504; // 504 - приложение Авиабилетов под андроид
const BILLING_PLATFORM_WINDOWS_PHONE_AVIA = 505; // 505 - приложение Авиабилетов windows phone
// const BILLING_PLATFORM_IPAD = 506; // 506 - приложение Авиабилетов для ipad
// const BILLING_PLATFORM_ANDROID_TABLET = 507; // 507 - приложение Авиабилетов для android tablet
const BILLING_PLATFORM_MOBILE_AVIA = 508; // 508 - тач-версия (смартфоны)
// const BILLING_PLATFORM_TABLET_AVIA = 509; // 509 - планшет
const BILLING_PLATFORM_IOS_TRAVEL = 513; // 513 - приложение Травела под iOS
const BILLING_PLATFORM_ANDROID_TRAVEL = 514; // 514 - приложение Травела под андроид

/**
 * Для простановки параметра pp в логе редиректов авиа (https://wiki.yandex-team.ru/avia/pp/)
 * Сейчас используются не все коды. В свое время потеряли логику по их установке.
 * На данный момент добавляем только нужное: https://st.yandex-team.ru/TRAVELFRONT-6434#6169689a383bbf67c7590b63
 */
export function getAviaBillingPlatform(req: Request): number {
    const {isMobile} = req.uatraits;
    const platform = req.platform;

    switch (platform) {
        case Platforms.WEB:
            return isMobile
                ? BILLING_PLATFORM_MOBILE_AVIA
                : BILLING_PLATFORM_AVIA;
        case Platforms.ANDROID:
            return req.isTravelApp
                ? BILLING_PLATFORM_ANDROID_TRAVEL
                : BILLING_PLATFORM_ANDROID_AVIA;
        case Platforms.IOS:
            return req.isTravelApp
                ? BILLING_PLATFORM_IOS_TRAVEL
                : BILLING_PLATFORM_IOS_AVIA;
        case Platforms.WP:
            return BILLING_PLATFORM_WINDOWS_PHONE_AVIA;
        default:
            return BILLING_PLATFORM_AVIA;
    }
}
