import {IUATraits} from 'types/common/IUATraits';
import {EAviaProjectCode} from 'types/avia/EAviaProjectCode';

export function getAviaServiceName(
    uatraits: IUATraits,
    isTravelApp: boolean,
): EAviaProjectCode {
    if (isTravelApp) {
        return EAviaProjectCode.TRAVEL_APP;
    }

    return uatraits.isMobile
        ? EAviaProjectCode.MOBILE
        : EAviaProjectCode.DESKTOP;
}
