import {INationalClickPriceMap} from 'server/api/AviaPartnersApi/AviaPartnersApi';

import {getPriceByNation} from './getPriceByNation';
import {getCentsDispersed} from './getCentsDispersed';

export function getPriceByNationWithDispersedCents(
    priceMap: INationalClickPriceMap,
    nationalVersion: string,
): number {
    const price = getPriceByNation(priceMap, nationalVersion);

    return getCentsDispersed(price) || 0;
}
