import moment from 'moment';

import {TLogPlainObject} from '../types/TLogPlainObject';

import {ILoggerConstructorParams} from 'server/utilities/Logger/AppLogger';

import {BaseFileLogger} from './BaseFileLogger';

export class BaseTSKVLog extends BaseFileLogger {
    private type: string;

    constructor(
        params: ILoggerConstructorParams,
        destination: string | null,
        type: string,
    ) {
        super(params, destination);

        this.type = type;
    }

    protected format<T>(msg: T): string {
        const unixTime = moment.utc().unix();

        const data = this.parseValues(msg);
        const header = `tskv\ttskv_format=${this.type}\tunixtime=${unixTime}\t`;

        const record = Object.keys(data)
            .map(name => `${name}=${data[name]}`)
            .join('\t');

        return `${header}${record}`;
    }

    private parseValues(data: any): TLogPlainObject {
        return Object.keys(data).reduce((newData, k) => {
            const keyType = typeof data[k];

            if (keyType === 'boolean') {
                data[k] = String(data[k]);
            } else if (
                keyType !== 'string' &&
                (keyType !== 'number' || isNaN(data[k]))
            ) {
                data[k] = '';
            }

            newData[k] = data[k];

            return newData;
        }, {} as TLogPlainObject);
    }
}
