import {get} from 'lodash';

import {EProjectName} from 'constants/common';

import {IAviaLogConfig} from '../avia/types/IAviaLogConfig';
import {CoreConfig} from '@yandex-data-ui/core/lib/types';

import {TLogger, TErrorLogger} from 'server/utilities/Logger';

export type TGetFileLoggerWrapperGetter = (
    log: TLogger,
    logWarn: TErrorLogger,
    logError: TErrorLogger,
    config: CoreConfig,
) => TFileLoggerWrapperGetter;

export type TFileLoggerWrapperGetter = (
    project: EProjectName,
    logName: string,
) => IFileLoggerWrapper;

interface IFileLoggerWrapper {
    logger: {
        log: TLogger;
        logWarn: TErrorLogger;
        logError: TErrorLogger;
    };
    config: Nullable<IAviaLogConfig>;
}

export function getFileLoggerWrapperGetter(
    log: TLogger,
    logWarn: TErrorLogger,
    logError: TErrorLogger,
    config: CoreConfig,
): TFileLoggerWrapperGetter {
    return (project: EProjectName, logName: string): IFileLoggerWrapper => {
        return {
            logger: {
                log,
                logWarn,
                logError,
            },
            config: get(config, ['fileLogging', project, logName], null),
        };
    };
}
