import fs from 'fs';
import cluster from 'cluster';
import os from 'os';

import {writeToLog} from './writeToLog';

const FILE_NAME = 'log.txt';

// для того чтобы проверить что логи пишутся без ошибок
// если одновременно писать в один файл из нескольких потоков

if (cluster.isMaster) {
    for (let i = 0; i < 10; i++) cluster.fork();
} else {
    const i = 10000;

    logNext(i).then(checkLogs);
}

function logNext(i: number): Promise<void> {
    if (i === 0) return Promise.resolve();

    const message = JSON.stringify({log: true, i, msg: 'test message'});

    writeToLog({
        message,
        destination: FILE_NAME,
        onError: e => console.log(`stream error`, e),
    });

    return new Promise(resolve => {
        setTimeout(() => {
            logNext(i - 1).then(resolve);
        });
    });
}

function checkLogs(): void {
    const file = fs.readFileSync(FILE_NAME, 'utf8');
    const parts = file.split(os.EOL);

    let hasErrors = false;

    for (let i = 0; i < parts.length - 1; i++) {
        try {
            JSON.parse(parts[i]);
        } catch (e) {
            console.log(`---`);
            console.log(`error`, e);
            console.log(`---`);
            console.log(`json`, parts[i]);
            console.log(`index`, i);
            hasErrors = true;
        }
    }

    if (!hasErrors) {
        console.log('ok');
    }
}
