import {createWriteStream} from 'fs';
import os from 'os';

interface IWriteToLogParams {
    message: string;
    destination: string;
    onError: (e: Error) => void;
}

export function writeToLog({
    message,
    destination,
    onError,
}: IWriteToLogParams): void {
    const stream = createWriteStream(destination, {
        flags: 'a',
    }).on('error', onError);

    stream.once('open', () => {
        stream.write(`${message}${os.EOL}`);

        stream.end();
    });
}
