const onHeaders = require('on-headers');

/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 * @typedef {import('@yandex-data-ui/core/lib/types').Response} Response
 * @typedef {import('@yandex-data-ui/core/lib/types').NextFunction} NextFunction
 */

/**
 * @param {Request} _
 * @param {Response} res
 * @param {NextFunction} next
 * @returns {undefined}
 */
module.exports = (_, res, next) => {
    onHeaders(res, assignCookies);

    const cookieStorage = {};

    /**
     * @this Response
     * @returns {undefined}
     * */
    function assignCookies() {
        Object.keys(cookieStorage).forEach(cookieName =>
            this.cookie(
                cookieName,
                cookieStorage[cookieName].value,
                cookieStorage[cookieName].params,
            ),
        );
    }

    res.aviaCookie = (cookieName, cookieValue, cookieParams = {}) => {
        cookieStorage[cookieName] = {
            value: cookieValue,
            params: cookieParams,
        };
    };

    res.aviaClearCookie = cookieName => {
        cookieStorage[cookieName] = cookieStorage[cookieName] || {
            value: '',
            params: {},
        };

        Object.assign(cookieStorage[cookieName].params, {
            expires: new Date(1),
        });
    };

    res.hasCookie = cookieName => Boolean(cookieStorage[cookieName]);

    res.getCookie = cookieName => ({...cookieStorage[cookieName]});

    next();
};
