const urlDecode = require('../utilities/urlDecode/urlDecode');

/**
 * Декодирует URL, которые по какой-то причине имеют вид
 * /route?p1=1&amp;p2=2 вместо /route?p1=1&p2=2
 * @see: https://st.yandex-team.ru/TRAVELFRONT-6158
 *
 * @param {Request} req
 * @param {Response} res
 * @param {NextFunction} next
 * @returns {void}
 */
function decodeUrlMiddleware(req, res, next) {
    const path = req.originalUrl;

    const decodedPath = urlDecode(path);

    if (path !== decodedPath) {
        res.redirect(302, decodedPath);

        return;
    }

    next();
}

module.exports = decodeUrlMiddleware;
