const cookies = require('../utilities/cookies');
const {
    generateCookieName,
    meetExperimentDependencies,
    getOrSetExperimentCookie,
    completeExperimentData,
    parseRawValue,
    sortExperimentKeysByDeps,
} = require('../utilities/experiments');

module.exports = function featuresMiddleware(req, res, next) {
    const features = {};
    const experimentsKeys = Object.keys(req.utils.config.experiments);
    const getExperimentsValues = Object.values(
        req.utils.config.experiments,
    ).map(experiment =>
        typeof experiment === 'function' ? experiment(req) : experiment,
    );

    return Promise.all(getExperimentsValues)
        .then(experimentsValues => {
            const experiments = {};

            experimentsKeys.forEach((key, index) => {
                if (experimentsValues[index]) {
                    experiments[key] = completeExperimentData(
                        experimentsValues[index],
                    );
                }
            });

            const keys = sortExperimentKeysByDeps(experiments);

            keys.forEach(key => {
                const experiment = experiments[key];
                const {denied, defaultValue, dependencies} = experiment;
                const rawValue =
                    req.query && req.query[generateCookieName(key)];

                if (rawValue !== undefined) {
                    // Перекрываем значениями из query
                    features[key] = parseRawValue(rawValue, experiment);

                    return;
                }

                if (
                    !dependencies ||
                    meetExperimentDependencies(dependencies, features)
                ) {
                    // выполнены условия родительских экспериментов
                    if (denied) {
                        // если эксперимент запрещен, то выставляем дефолтное значение
                        features[key] = defaultValue;
                    } else {
                        // Считаем значения экспериментов в соответствии с конфигом
                        features[key] = getOrSetExperimentCookie(
                            key,
                            experiment,
                            cookies(req, res),
                        );
                    }
                }
            });

            req.features = features;
            next();
        })
        .catch(() => {
            req.features = features;
            next();
        });
};
