import {
    Request,
    Response,
    NextFunction,
} from '@yandex-data-ui/core/build/types';

const travelAppHeaderName = 'x-travel-app';
const travelAppCookieName = 'travel-app';

function setTravelApp(req: Request, res: Response): void {
    const header = req.headers[travelAppHeaderName];
    const cookies = req.cookies[travelAppCookieName];

    let isTravelApp = header || cookies;

    if (Array.isArray(isTravelApp)) {
        isTravelApp = isTravelApp[0];
    }

    if (isTravelApp !== 'true') {
        req.isTravelApp = false;

        return;
    }

    if (isTravelApp !== cookies) {
        res.cookie(travelAppCookieName, isTravelApp, {httpOnly: true});
    }

    req.isTravelApp = true;
}

export default function isTravelAppMiddleware(
    req: Request,
    res: Response,
    next: NextFunction,
): void {
    try {
        setTravelApp(req, res);
    } catch (e) {
        req.utils.logError('isTravelAppMiddleware', e);
    }

    next();
}
