/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 * @typedef {import('@yandex-data-ui/core/lib/types').Response} Response
 * @typedef {import('@yandex-data-ui/core/lib/types').NextFunction} NextFunction
 */

const defaultNativeAppVersion = '0.0.0';

const headerName = 'x-avia-platform-version';
const cookieName = 'avia-platform-version';

function isValidVersion(str) {
    return Boolean(str) && /^[0-9]+(?:\.[0-9]+)*$/.test(str);
}

/**
 * @param {Request} req
 * @param {Response} res
 * @returns {void}
 */
function setNativeAppVersion(req, res) {
    let version = req.headers[headerName] || req.cookies[cookieName];

    if (isValidVersion(version)) {
        res.cookie(cookieName, version, {httpOnly: true});
    } else {
        version = defaultNativeAppVersion;
    }

    if (req.isFakeApp) {
        version = '99.9.9';
    }

    req.nativeAppVersion = version;
}

/**
 * @param {Request} req
 * @param {Response} res
 * @param {NextFunction} next
 * @returns {void}
 */
function nativeAppVersionMiddleware(req, res, next) {
    try {
        setNativeAppVersion(req, res);
    } catch (e) {
        req.utils.logError('nativeAppVersionMiddleware', e);
    }

    next();
}

module.exports = {
    nativeAppVersionMiddleware,
    defaultNativeAppVersion,
};
