const uuidV4 = require('uuid').v4;

module.exports = (req, res, next) => {
    const cookieSessionSecret = req.utils.config.cookieSession.secret;

    if (!cookieSessionSecret) {
        req.utils.logError('MISSING_COOKIE_SESSION_SECRET');
    }

    if (req.session.isNew) {
        req.session.yaTravelSessionUid = uuidV4();
    }

    next();
};
