const {set} = require('lodash');

const getUserNetworkTraits = require('../providers/geoBase/getUserNetworkTraits');

module.exports = async (req, _res, next) => {
    const traits = await getUserNetworkTraits(req);

    if (traits) {
        const {is_yandex_net: isYandexNetwork, region_id: geoId} = traits;

        req.userInfo = req.userInfo || {};
        set(req.userInfo, 'isYandexNetwork', isYandexNetwork);

        req.geoId = geoId;
    }

    next();
};
