import {Request, Response, NextFunction} from '@yandex-data-ui/core/lib/types';

import getWhiteLabelPartnerFromReq from 'server/utilities/getWhiteLabelPartnerFromReq';

export default function whiteLabelMiddleware(
    req: Request,
    res: Response,
    next: NextFunction,
): void {
    try {
        req.partner = getWhiteLabelPartnerFromReq(req);
    } catch (error) {
        req.utils.logError('whiteLabelMiddleware', error);
        req.partner = null;
    }

    next();
}
