const axios = require('axios');
const NodeCache = require('node-cache');

const SERVICE_CODE = 'avia-frontend';

const cache = new NodeCache({stdTTL: 5 * 60});

module.exports.getFeatures = async function (req) {
    const dataFromCache = cache.get(SERVICE_CODE);

    if (dataFromCache) {
        return dataFromCache;
    }

    try {
        const {data} = await axios.get(
            `${req.utils.config.servicesAPI.aviaFeatures}/feature-flag`,
            {
                params: {
                    'service-code': SERVICE_CODE,
                },
            },
        );

        cache.set(SERVICE_CODE, data);

        return data;
    } catch (e) {
        req.utils.logError('AVIA_ERROR', e, {
            uid: req.cookies.yandexuid,
            level: 'avia providers',
            data: 'actionType: getFeatures',
        });

        return null;
    }
};
